import * as humans from "../Humans";
import * as classes from "../Classes";
import { School } from "../School";
import { ActionFormData, MessageFormData, ModalFormData } from "@minecraft/server-ui";
import { Player, world } from "@minecraft/server";

/*
- list of schools
    - list of classes
        - list of students
    - list of personal
    - additional information
+ edit schools
    + edit classes
        -> name, grade
    + edit personal
        -> add/remove, change subjects
    + edit information
        -> name, perfil
    + edit students
        -> add/remove
+ edit humans
    -> edit everything

*/

/**
 * 
 * @param {Player} player 
 */
export function editSchools(player){
    //
    let schoolsMenu = new ActionFormData(); schoolsMenu.title("Data Editor School"); schoolsMenu.body("Select a School's data to edit");
    let dataEditorSelector = new ActionFormData(); dataEditorSelector.title("Data Editor School"); dataEditorSelector.body("Select what to edit"); dataEditorSelector.button("Classes"); dataEditorSelector.button("Personal"); dataEditorSelector.button("Information"); dataEditorSelector.button("Students"); dataEditorSelector.button("Add/remove students");
    //
    let classSelectionMenu = new ActionFormData(); classSelectionMenu.title("Data Editor School"); classSelectionMenu.body("Select a Class's data to edit");
    let classesMenu = new ModalFormData(); classesMenu.title("Data Editor School");
    //
    let personalSelectionMenu = new ActionFormData(); personalSelectionMenu.title("Data Editor School"); personalSelectionMenu.body("Select a Personal's data to edit");
    let personalsMenu = new ModalFormData(); personalsMenu.title("Data Editor School");
    //
    let informationMenu = new ModalFormData(); informationMenu.title("Data Editor School");
    //
    let studentSelectionMenu = new ActionFormData(); studentSelectionMenu.title("Data Editor School"); studentSelectionMenu.body("Select a Student's data to edit");
    let studentsMenu = new ModalFormData(); studentsMenu.title("Data Editor School");
    //
    let studentManageMenu = new ModalFormData(); studentManageMenu.title("Data Editor School");

    for(let sc = 0; sc < School.schools.length; sc++){
        schoolsMenu.button(School.schools[sc].name);
    };
    if(School.schools.length==0){player.sendMessage("No schools to edit! run jo:schoolCreator to create one"); return;};
    schoolsMenu.show(player).then((r1)=>{
        if(r1.canceled){return;};
        dataEditorSelector.show(player).then((r2)=>{
            if(r2.canceled){return;};
            /**
             * @type {School}
             */
            let s = School.schools[r1.selection];
            switch(r2.selection){
                case 0: for(let cl = 0; cl < s.classes.length; cl++){classSelectionMenu.button(`${s.classes[cl].grade}${s.classes[cl].letter}`)}; if(s.classes.length == 0){player.sendMessage("No classes in school! Add at least 1 to edit!"); return;};classSelectionMenu.show(player).then((r3)=>{
                    if(r3.canceled){return;}; 
                    /** 
                     * @type {classes.SchoolClass}
                    */ let c = s.classes[r3.selection]; classesMenu.textField("Letter of this class", "A, a, Ab, cD,...", c.letter); classesMenu.slider("This class' grade", 1, 12, 1, c.grade); classesMenu.textField("Main teachers", "Identifiers", c.mainTeacher.identifier); classesMenu.show(player).then((r4)=>{
                        if(r4.canceled){return;}; if(r4.formValues[0]!=""){c.letter=r4.formValues[0];};c.grade=r4.formValues[1]; if(humans.Human.lookForHuman(r4.formValues[2])==undefined){return;}else {c.mainTeacher = humans.Human.lookForHuman(r4.formValues[2])};
                    })});break;
                case 1: for(let pe = 0; pe < s.personal.length; pe++){personalSelectionMenu.button(`${s.personal[pe].name} ${s.personal[pe].name} (${s.personal[pe].identifier})`)}; personalSelectionMenu.show(player).then((r5)=>{if(r5.canceled){return;};
                    /**
                     * @type {humans.Teacher}
                     */
                    let p = s.personal[r5.selection]; personalsMenu.toggle("Is Teacher?", s.teachers.includes(p)); personalsMenu.toggle("Is Headmaster?", p==s.headmaster); personalsMenu.textField("Teacher's subjects", "Subject Shorts (En,Geo,Ma...)", "Maths"); personalsMenu.show(player).then((r6)=>{
                        if(r6.canceled){return;}; p.subjects=r6.formValues[2].split(", "); if(r6.formValues[0]==true){if(!p instanceof humans.Teacher){if(p.type==0){p=p.becomeTeacher();}else{p=p.becomeHuman().becomeTeacher();};}; if(!s.teachers.includes(p)){s.teachers.push(p);};}else {if(s.teachers.includes(p)){for(let te = 0; te < s.teachers.length; te++){if(s.teachers[te].identifier==p.identifier){s.teachers.splice(te, 1);};}}}; if(r6.formValues[1]==true){s.headmaster=p;}else {if(s.headmaster.identifier==p.identifier){player.sendMessage("Cannot unset the headmaster! You need to set another as a headmaster");}};
                    })});break;
                case 2: informationMenu.textField("School's name", "Name", s.name);let pred1 = (element) => element==s.perfil[0]; informationMenu.dropdown("First Perfil Subject", classes.SchoolSubject.AllTogether.split(", "), classes.SchoolSubject.AllTogether.split(", ").findIndex(pred1)); let pred2 = (element) => element==s.perfil[1]; informationMenu.dropdown("School's second perfil subject", classes.SchoolSubject.AllTogether.split(", "), classes.SchoolSubject.AllTogether.split(", ").findIndex(pred2)); informationMenu.show(player).then((r7)=>{if(r7.canceled){return;}; if(r7.formValues[0]!=""){s.name=r7.formValues[7]}; s.perfil=[ classes.SchoolSubject.AllTogether.split(", ")[r7.formValues[1]], classes.SchoolSubject.AllTogether.split(", ")[r7.formValues[1]]]}); break;
                case 3: for(let st = 0; st < s.students.length; st++){studentSelectionMenu.button(`${s.students[st].name} ${s.students[st].familyName}`);}; if(s.students.length==0){player.sendMessage("No students in school! Add at least one to edit"); return;}; studentSelectionMenu.show(player).then((r8)=>{
                    /**
                     * @type {humans.Student}
                     */
                    let sd = s.students[r8]; let opt2 = [];let iC; for(let cl2 = 0; cl2 < s.classes.length; cl2++){opt2.push(`${s.classes[cl2].grade}${s.classes[cl2].letter}`); if(s.classes[cl2].students.includes(sd)){iC = cl2}};studentsMenu.dropdown("in class...", opt2, iC); studentsMenu.show(player).then((r9)=>{if(r9.canceled||r9.formValues[0]==iC){return;}; if(s.classes[cl2].students.includes(sd)){s.expulseStudent(sd.identifier); s.addStudents([sd], iC) }})}); 
                    break;
                case 4: studentManageMenu.textField("Student's Id", "Id"); studentManageMenu.toggle("remove|add from school", true); studentManageMenu.toggle("Random class?", false); let opt3 = [];for(let cc = 0; cc < s.classes.length; cc++){opt3.push(`${s.classes[cc].grade}${s.classes[cc].letter}`)};if(s.classes.length==0){player.sendMessage("No classes in school to add a student to!");return;}; studentManageMenu.dropdown("Class to add to", opt3, 0); studentManageMenu.show(player).then((r10)=>{
                    if(r10.canceled){return;}; if(r10.formValues[1]==true){if(r10.formValues[2]==true){s.addStudents([humans.Human.lookForHuman(r10.formValues[0])], "Random_");}else {s.addStudents(humans.Human.lookForHuman(r10.formValues[0]), r10.formValues[3]);};}else {s.expulseStudent(r10.formValues[0]);};
                    }); break;
                default: break;
            };
        })
    })
}